rollout DYNmrSunLight ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj

  /* /// remaining parameters ///
    <mr_Sun>.color Color default: (color 255 242.25 229.5) -- color by value
    <mr_Sun>.excludeList Array default: #() -- value
    <mr_Sun>.includeList UndefinedClass default: undefined -- value;
    <mr_Sun>.maxDepth Integer default: 7 -- animatable; integer; Max_Quadtree_Depth
    <mr_Sun>.raytraceBias Float default: 0.2 -- animatable; float; Bias
    <mr_Sun>.raytracedShadows BooleanClass default: true -- value
    <mr_Sun>.rgb Color default: (color 255 242.25 229.5) -- animatable; RGB color; Controller Scaling: ([1,1,1] : (color 255 255 255));
    <mr_Sun>.shadowGenerator raytraceShadow default: raytraceShadow:raytraceShadow -- value; SubAnim
    <mr_Sun>.shadowGeneratorByName String default: "Ray Traced Shadows" -- value
    <mr_Sun>.skymult Float default: 1.0 -- animatable; float; Multiplier
    <mr_Sun>.twoSidedShadows BooleanClass default: false -- boolean
    <mr_Sun>.useGlobalShadowSettings BooleanClass default: false -- boolean; Use_Global_Shadow_Settings
  */

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNsunParams FUNsun =
  (
    DYNmrSunLight.LOCobj = FUNsun

    if classOf FUNsun == mr_Sun then
    (
      DYNmrSunLight.LBDYNlightName.text       = FUNsun.name + " (mr Sun)"
      DYNmrSunLight.LOCobj                    = FUNsun
      DYNmrSunLight.CKDYNsunOn.checked        = FUNsun.on
      DYNmrSunLight.SPDYNsunMult.value        = FUNsun.skymult
      DYNmrSunLight.CKDYNshadows.checked      = FUNsun.baseObject.castShadows
      DYNmrSunLight.SPDYNsoftness.value       = FUNsun.shadowSoftness
      DYNmrSunLight.SPDYNsamples.value        = FUNsun.shadowSamples
      DYNmrSunLight.CKDYNinherit.checked      = FUNsun.inherit
      DYNmrSunLight.CKDYNtargeted.checked     = FUNsun.hasTarget
      DYNmrSunLight.SPDYNtargeted.value       = FUNsun.baseObject.targetDistance
      DYNmrSunLight.SPDYNredness.value        = FUNsun.RedBlueShift
      DYNmrSunLight.SPDYNsaturation.value     = FUNsun.Saturation
      DYNmrSunLight.SPDYNhaze.value           = FUNsun.haze
      DYNmrSunLight.SPDYNhorHeight.value      = FUNsun.HorizonHeight
      DYNmrSunLight.CKDYNusePhotons.checked   = FUNsun.usePhotonTarget
      DYNmrSunLight.SPDYNradius.value         = FUNsun.photonTarget
      DYNmrSunLight.SPDYNtargeted.enabled     = not DYNmrSunLight.CKDYNtargeted.checked
      DYNmrSunLight.SPDYNredness.enabled      = DYNmrSunLight.LBDYNredness.enabled      = not FUNsun.inherit
      DYNmrSunLight.SPDYNsaturation.enabled   = DYNmrSunLight.LBDYNsaturation.enabled   = not FUNsun.inherit
      DYNmrSunLight.SPDYNhaze.enabled         = DYNmrSunLight.LBDYNhaze.enabled         = not FUNsun.inherit
      DYNmrSunLight.SPDYNhorHeight.enabled    = DYNmrSunLight.LBDYNhorHeight.enabled    = not FUNsun.inherit
    )
    else
    (
      for i in DYNmrSunLight.controls do i.enabled = false
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  label LBDYNlightName align:#center

  groupbox GBDYNgroup00 pos:[4,24] width:(DYNiniExplorerWidth - 21) height:87
  checkbox CKDYNsunOn align:#left pos:[13,45]
  label   LBDYNsunMult  align:#left pos:[13,67]
  spinner  SPDYNsunMult align:#left pos:[(DYNiniExplorerWidth - 96),65] range:[0.0,10.0,1.0] type:#float   fieldwidth:60 scale:0.01
  checkbox CKDYNtargeted   align:#left pos:[13,87] width:20
  label   LBDYNtargeted    align:#left pos:[33,87]
  spinner SPDYNtargeted    align:#left pos:[(DYNiniExplorerWidth - 96),85] range:[0.0,100000000.0,1.0] type:#float fieldwidth:60 scale:0.1

  groupbox GBDYNgroup01 pos:[4,116] width:(DYNiniExplorerWidth - 21) height:82
  checkbox CKDYNshadows pos:[13,135] align:#left
  label   LBDYNsoftness  align:#left pos:[13,156]
  spinner SPDYNsoftness   align:#left pos:[(DYNiniExplorerWidth - 96),154] range:[0.0,50.0,1.0] type:#float fieldwidth:60 scale:0.1
  label   LBDYNsamples    align:#left pos:[13,176]
  spinner SPDYNsamples    align:#left pos:[(DYNiniExplorerWidth - 96),174] range:[0,1000,0] type:#integer fieldwidth:60

  groupbox GBDYNgroup03    pos:[4,205] width:(DYNiniExplorerWidth - 21) height:123
  checkbox CKDYNinherit pos:[13,223] align:#left
  label   LBDYNhaze        pos:[13,245] align:#left
  spinner  SPDYNhaze       pos:[(DYNiniExplorerWidth - 96),243] align:#left range:[0.0,15.0,0.0] type:#float fieldwidth:60 scale:0.1
  label   LBDYNhorHeight   pos:[13,265] align:#left
  spinner SPDYNhorHeight   pos:[(DYNiniExplorerWidth - 96),263] align:#left range:[-10.0,10.0,1.0] type:#float fieldwidth:60 scale:0.1
  label   LBDYNredness     pos:[13,285] align:#left
  spinner SPDYNredness     pos:[(DYNiniExplorerWidth - 96),283] align:#left range:[-1.0,1.0,1.0] type:#float fieldwidth:60 scale:0.01
  label   LBDYNsaturation  pos:[13,305] align:#left
  spinner SPDYNsaturation  pos:[(DYNiniExplorerWidth - 96),303] align:#left range:[0.0,2.0,1.0]  type:#float fieldwidth:60 scale:0.05

  groupbox GBDYNgroup04    pos:[4,335] width:(DYNiniExplorerWidth - 21) height:65
  checkbox CKDYNusePhotons pos:[13,353] align:#left
  label   LBDYNradius      pos:[13,373] align:#left
  spinner SPDYNradius      pos:[(DYNiniExplorerWidth - 96),373] align:#left range:[0.0,100000000.0,1.0] type:#float fieldwidth:60 scale:0.01
  button BUDYNtimeDate width:(DYNiniExplorerWidth - 21) align:#center pos:[4,405]


  on DYNmrSunLight open do
  (
    DYNmrSunLight.title   = DYNuiRolloutNames[30]

    GBDYNgroup00.text     = DYNuiResourcesGroups[67]
    GBDYNgroup03.text     = DYNuiResourcesGroups[80]
    GBDYNgroup01.text     = DYNuiResourcesGroups[83]
    GBDYNgroup04.text     = DYNuiResourcesGroups[84]

    CKDYNsunOn.text       = DYNuiResourcesLabels[22]
    LBDYNsunMult.text     = DYNuiResourcesLabels[131]
    CKDYNshadows.text     = DYNuiResourcesLabels[22]
    LBDYNredness.text     = DYNuiResourcesLabels[258]
    LBDYNsaturation.text  = DYNuiResourcesLabels[259]
    LBDYNhaze.text        = DYNuiResourcesLabels[255]
    LBDYNradius.text      = DYNuiResourcesLabels[186]
    LBDYNhorHeight.text   = DYNuiResourcesLabels[256]
    LBDYNsoftness.text    = DYNuiResourcesLabels[263]
    LBDYNsamples.text     = DYNuiResourcesLabels[264]
    LBDYNtargeted.text    = DYNuiResourcesLabels[265]
    CKDYNinherit.text     = DYNuiResourcesLabels[266]
    CKDYNusePhotons.text  = DYNuiResourcesLabels[267]

    BUDYNtimeDate.text    = DYNuiResourcesButtons[60]
  )

  on BUDYNtimeDate pressed do
  (
    cui.commandPanelOpen = true
    max motion mode
    messagebox (DYNuiResourcesErrorsWarnings[31]) title:DYNuiResourcesTitlebars[3]
  )

  on CKDYNsunOn changed arg do
  (
    LOCobj.on = arg
    if DYNLightList.open then
    (
      DYNlightList.DYNFUNupdateLightInstances LOCobj
    )
  )

  on SPDYNsunMult changed arg do LOCobj.skymult = arg
  on SPDYNsunMult entered do
  (
    if DYNLightList.open then
    (
      DYNlightList.DYNFUNupdateLightInstances LOCobj

      local LOCitem = DYNFUNfindListViewItemByTag DYNlightList.dnLights (LOCobj.inode.handle as string)
      if LOCitem != undefined then LOCitem.SubItems.item[1].text = SPDYNsunMult.value as string
    )
  )

  on CKDYNtargeted    changed arg do (LOCobj.hasTarget = arg; SPDYNtargeted.enabled = not arg)
  on SPDYNtargeted    changed arg do (LOCobj.baseObject.targetDistance = arg)
  on CKDYNshadows     changed arg do (LOCobj.baseObject.castShadows = arg)
  on SPDYNsoftness    changed arg do (LOCobj.shadowSoftness = arg)
  on SPDYNsamples     changed arg do (LOCobj.shadowSamples = arg)
  on CKDYNinherit     changed arg do
  (
    LOCobj.inherit = arg
    SPDYNredness.enabled      = LBDYNredness.enabled      = not arg
    SPDYNsaturation.enabled   = LBDYNsaturation.enabled   = not arg
    SPDYNhaze.enabled         = LBDYNhaze.enabled         = not arg
    SPDYNhorHeight.enabled    = LBDYNhorHeight.enabled    = not arg
  )
  on SPDYNhaze        changed arg do (LOCobj.haze = arg)
  on SPDYNhorHeight   changed arg do (LOCobj.HorizonHeight = arg)
  on SPDYNsaturation  changed arg do (LOCobj.saturation = arg)
  on SPDYNredness     changed arg do (LOCobj.RedBlueShift = arg)
  on CKDYNusePhotons  changed arg do (LOCobj.usePhotonTarget = arg)
  on SPDYNradius      changed arg do (LOCobj.photonTarget = arg)
)
